module
	primes

import
	StdEnv

isPrime :: !Int -> Bool
isPrime n
	| n <= 2					= False
	= not (canBeDividedByAny [2..n-1] n)

canBeDividedByAny :: ![Int] !Int -> Bool
canBeDividedByAny [] n
	= False
canBeDividedByAny [m:ms] n
	| n rem m == 0				= True
	= canBeDividedByAny ms n

primes :: [Int]
primes
	= filter isPrime [0..]

Start :: [Int]
Start
	= take 100 primes